#include "statistics.h"

double mean(std::vector<double> &array)
{
    int n = array.size();
    double m = 0;
    for(int i = 0; i < n; i++)
    {
        m += array[i];
    }
    return m/n;
}

double cov_func(int t, std::vector<double> &o) //autocovariance-function
{
    int n = o.size();

    double a = 0;
    double b = 0;
    double c = 0;
    for(int i=0; i < n-t; i++)
    {
        a += o[i]*o[i+t];
        b += o[i];
        c += o[i+t];
    }
    a = a/(1.0*n-t);
    b = b/(1.0*n-t);
    c = c/(1.0*n-t);

    return a-(b*c);
}

double int_auto(std::vector<double> &o) //integrated autocorrelation-time
{
    int n = o.size();

    double sum = 0.0;
    double cov_0 = cov_func(0, o);
    for(int t=1; t < n; t++)
    {
        if(cov_func(t, o) >= 0 && cov_0 != 0)
        {
	    sum += (1-t/(1.0*n))*cov_func(t, o)/cov_0;
        }
        else break;
    }

    return 0.5+sum;
}

double error(std::vector<double> &o, double tau) //error on expectation for given observable
{
    int n = o.size();
    return sqrt(2*tau*cov_func(0, o)/(1.0*n));
}

int d2i(double d) //round double to int
{
  return d<0?d-.5:d+.5;
}

void calculate_observable(std::vector<double> &old_data, std::vector<double> &new_data, double &o_mean, double &o_error)
{
  new_data.resize(0);
  
  unsigned int counter;
  double autot = int_auto(old_data);
  int size = old_data.size();
  if(d2i(20*autot) >= size)
  {
    std::cerr << "Thermalisation not reached! " << d2i(20*autot) << " steps needed, but data size is " << size << "." << std::endl;
    return;
  }
  for(int i = 0; i < size-d2i(20*autot); i++)
  {
    new_data.push_back( old_data[i+d2i(20*autot)] );
  }
    
  autot = int_auto(new_data);
  counter = 0;
  size = new_data.size();
  for(int i = 0; i < size; i += d2i(2.0*autot))
  {
    new_data[counter] = new_data[i];
    counter++;
  }
  new_data.resize(size/d2i(2.0*autot));

  o_mean  = mean(new_data);
  o_error = error(new_data, autot);
}
